import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
empty_clean_color = 'white'
text_color = 'black'

# Add dispensers
ax.add_patch(patches.Rectangle((0.1, 0.8), 0.2, 0.1, facecolor=ingredient1_color, edgecolor='black'))
ax.text(0.2, 0.85, 'dispenser_1\ningredient1', ha='center', va='center', fontsize=8, color='white')

ax.add_patch(patches.Rectangle((0.7, 0.8), 0.2, 0.1, facecolor=ingredient2_color, edgecolor='black'))
ax.text(0.8, 0.85, 'dispenser_2\ningredient2', ha='center', va='center', fontsize=8, color='white')

# Add shots
ax.add_patch(patches.Rectangle((0.1, 0.5), 0.1, 0.1, facecolor=empty_clean_color, edgecolor='black'))
ax.text(0.15, 0.55, 'shot_1\nclean', ha='center', va='center', fontsize=8, color=text_color)

ax.add_patch(patches.Rectangle((0.45, 0.5), 0.1, 0.1, facecolor=empty_clean_color, edgecolor='black'))
ax.text(0.5, 0.55, 'shot_2\nclean', ha='center', va='center', fontsize=8, color=text_color)

ax.add_patch(patches.Rectangle((0.8, 0.5), 0.1, 0.1, facecolor=empty_clean_color, edgecolor='black'))
ax.text(0.85, 0.55, 'shot_3\nclean', ha='center', va='center', fontsize=8, color=text_color)

# Add shaker
ax.add_patch(patches.Circle((0.5, 0.3), 0.1, facecolor=empty_clean_color, edgecolor='black'))
ax.text(0.5, 0.3, 'shaker_1\nclean\nlevel l0', ha='center', va='center', fontsize=8, color=text_color)

# Add hands
ax.add_patch(patches.Rectangle((0.1, 0.1), 0.1, 0.05, facecolor=empty_clean_color, edgecolor='black'))
ax.text(0.15, 0.125, 'left_hand\nempty', ha='center', va='center', fontsize=8, color=text_color)

ax.add_patch(patches.Rectangle((0.8, 0.1), 0.1, 0.05, facecolor=empty_clean_color, edgecolor='black'))
ax.text(0.85, 0.125, 'right_hand\nempty', ha='center', va='center', fontsize=8, color=text_color)

# Legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1 (red)'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2 (blue)'),
    patches.Patch(facecolor=empty_clean_color, edgecolor='black', label='clean & empty (white)')
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and hide axes
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
ax.axis('off')

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_6.png')
plt.show()